import java.io.File;
import java.util.Scanner;

public class Problem_3_Airport_Radar {
    public static void main(String[] args) {

        try {
            Scanner file = new Scanner(new File("C:\\Users\\Mike\\Desktop\\problem_3_airport_radar_DATA30.txt"));

            while (file.hasNextLine()) { // every line of data in the file

                 // line that contains the distance and angle of plane, and n for the next n lines of data corresponding to this plane
                String line = file.nextLine();
                
                String[] parts = line.split("\\s+"); // split by whitespace

                double theta = Double.parseDouble(parts[0]), distance = Double.parseDouble(parts[1]); // angle and distance of plane flight (1st and 2nd part of line)
                int n = Integer.parseInt(parts[2]); // next n lines of data corresponds to this plane flight (3rd part of line)
                
                int radarAppearances = 0;

                for (int q = 0; q < n; q++) { // for next n lines
                    
                    line = file.nextLine(); // next line in file (this line of data corresponds to the flight path of the plane above)
                    parts = line.split("\\s+"); // split by whitespace
                    
                    // i and j represent the coordinate of the radar tower, and r represents the radius (its range)
                    double i = Double.parseDouble(parts[0]), j = Double.parseDouble(parts[1]), r = Double.parseDouble(parts[2]);
    
                    // primary trigonometric ratios using polar coordinates to find x and y
                    // x and y represent the coordinate of the plane at the end of its flight
                    // multiply by pi/180 because Math.cos and Math.sin take in a radian measure as a parameter
                    double x = distance * Math.cos(theta * Math.PI / 180);
                    double y = distance * Math.sin(theta * Math.PI / 180);

                    // starts at origin, so slope of plane flight is y/x; y-intercept should always be zero
                    double m = y/x, k = y - m * x;

                    // ax^2 + bx + c   algebra done on paper to come up with these coefficients
                    double a = Math.pow(m, 2) + 1;
                    double b = (-2 * i - 2 * j * m + 2 * m * k);
                    double c = Math.pow(i, 2) + Math.pow(j, 2) + Math.pow(k, 2) - Math.pow(r, 2) - 2 * j * k;

                    // quadratic formula: x = [-b +- sqrt(b^2 - 4ac)] / 2a
                    double x1 = (-b + Math.sqrt(Math.pow(b, 2) - 4 * a * c)) / 2 / a;
                    double x2 = (-b - Math.sqrt(Math.pow(b, 2) - 4 * a * c)) / 2 / a;

                    // determining if the point(s) of intersection (if any) are within the plane's flight path
                    // (it's not an infinite line, so we need to test if the intersection occurs within the plane's length of flight vs just anywhere on the equation of the line)
                    if (x < 0) {
                        if (  (x1 < 0 && x1 >= x) || (x2 < 0 && x2 >= x) ) {
                            radarAppearances++;
                        }
                    } else if (x > 0) {
                        if (  (x1 > 0 && x1 <= x) || (x2 > 0 && x2 <= x) ) {
                            radarAppearances++;
                        }
                    }
                }
                System.out.println("The jet will appear on " + radarAppearances + " radar screens.");
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}